<?php
// Include database connection
include 'conn.php';

// Initialize variables
$student = null;
$assigned_books = [];
$available_books = [];
$message = "";
$message_type = ""; // To differentiate between success and different types of errors
$show_message = false;

// Check if form is submitted to fetch student details
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['admission_number'])) {
    // Retrieve and sanitize form data
    $admission_number = $conn->real_escape_string($_POST['admission_number']);

    // Fetch student details from the database
    $sql = "SELECT * FROM students WHERE admission_number = '$admission_number'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        // Fetch student details
        $student = $result->fetch_assoc();

        // Fetch books already assigned to the student
        $books_sql = "
            SELECT b.book_name, b.form
            FROM books_already_given bag
            JOIN books b ON bag.book_no = b.book_no
            WHERE bag.admission_number = '$admission_number'
        ";
        $books_result = $conn->query($books_sql);

        if ($books_result->num_rows > 0) {
            while ($row = $books_result->fetch_assoc()) {
                $assigned_books[] = $row;
            }
        }
    } else {
        $message = "No student found with this admission number.";
        $message_type = "error";
        $show_message = true;
    }
}

// Check if form is submitted to assign a book
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['book_no']) && isset($_POST['admission_number'])) {
    // Retrieve and sanitize form data
    $book_no = $conn->real_escape_string($_POST['book_no']);
    $admission_number = $conn->real_escape_string($_POST['admission_number']);

    // Check if the book exists in the books table
    $check_book_sql = "SELECT * FROM books WHERE book_no = '$book_no'";
    $check_book_result = $conn->query($check_book_sql);

    if ($check_book_result->num_rows === 0) {
        $message = "This book number does not exist in the database.";
        $message_type = "error";
        $show_message = true;
    } else {
        // Check the number of books already assigned to the student
        $count_sql = "SELECT COUNT(*) as book_count FROM books_already_given WHERE admission_number = '$admission_number'";
        $count_result = $conn->query($count_sql);
        $row = $count_result->fetch_assoc();
        $book_count = $row['book_count'];

        if ($book_count >= 3) {
            $message = "This student has already been assigned the maximum of three books.";
            $message_type = "error";
            $show_message = true;
        } else {
            // Check if the book is already assigned
            $check_book_assigned_sql = "SELECT * FROM books_already_given WHERE book_no = '$book_no'";
            $check_book_assigned_result = $conn->query($check_book_assigned_sql);

            if ($check_book_assigned_result->num_rows > 0) {
                $message = "This book has already been assigned to another student.";
                $message_type = "error";
                $show_message = true;
            } else {
                // Insert book information into books_already_given
                $insert_sql = "INSERT INTO books_already_given (book_no, admission_number) VALUES ('$book_no', '$admission_number')";

                if ($conn->query($insert_sql) === TRUE) {
                    $message = "Book successfully assigned to student.";
                    $message_type = "success";
                    $show_message = true;

                    // Refresh the assigned books list
                    $books_sql = "
                        SELECT b.book_name, b.form
                        FROM books_already_given bag
                        JOIN books b ON bag.book_no = b.book_no
                        WHERE bag.admission_number = '$admission_number'
                    ";
                    $books_result = $conn->query($books_sql);

                    if ($books_result->num_rows > 0) {
                        $assigned_books = [];
                        while ($row = $books_result->fetch_assoc()) {
                            $assigned_books[] = $row;
                        }
                    }
                } else {
                    $message = "Error: " . $insert_sql . "<br>" . $conn->error;
                    $message_type = "error";
                    $show_message = true;
                }
            }
        }
    }
}

// Fetch available books for the book search feature
$available_books_sql = "SELECT * FROM books";
$available_books_result = $conn->query($available_books_sql);
if ($available_books_result->num_rows > 0) {
    while ($row = $available_books_result->fetch_assoc()) {
        $available_books[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Library Management - Assign Books</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
  body {
    font-family: 'Roboto', sans-serif;
    margin: 0;
    padding: 0;
    background-color: #f5f7f9;
}

.navbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    background-color: #007bff;
    padding: 15px 30px;
    color: #ffffff;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    border-bottom: 1px solid #0056b3;
}

.navbar .clock {
    font-size: 24px;
    font-weight: bold;
}

.navbar .nav-links {
    display: flex;
    gap: 20px;
    align-items: center;
}

.navbar .nav-links a {
    color: #ffffff;
    text-decoration: none;
    font-size: 18px;
    font-weight: 500;
    transition: color 0.3s ease;
    display: flex;
    align-items: center;
}

.navbar .nav-links a i {
    margin-right: 8px;
}

.container {
    margin: 20px auto;
    padding: 20px;
    background-color: #ffffff;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    width: 95vw;
    max-width: 1200px;
}

.header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 2px solid #007bff;
    padding-bottom: 10px;
    margin-bottom: 20px;
}

.header h2 {
    margin: 0;
    color: #333;
    font-size: 26px;
    font-weight: bold;
}

.header .search-icon {
    font-size: 22px;
    color: #007bff;
    cursor: pointer;
}

        .form-group {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
            gap: 10px;
        }

        .form-group label {
            color: #555;
            font-weight: bold;
            width: 160px;
            font-size: 16px;
        }

        .form-group input {
            flex: 1;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 6px;
            box-sizing: border-box;
            font-size: 16px;
            transition: border-color 0.3s ease;
          
        }

        .form-group input:focus {
            border-color: #007bff;
            outline: none;
        }

        .form-group .btn-submit {
            padding: 12px 20px;
            background-color: #007bff;
            color: #ffffff;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            transition: background-color 0.3s ease;
        }

        .form-group .btn-submit:hover {
            background-color: #0056b3;
        }

        .btn-submit2 {
            padding: 12px 20px;
            background-color: #28a745;
            color: #ffffff;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            transition: background-color 0.3s ease;
            text-align: center;
            display: block;
            margin: 20px auto;
        }

        .dashboard {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }

        .student-info, .book-form, .available-books {
            flex: 1;
            min-width: 280px;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            background-color: #ffffff;
        }
        ..assigned-books{
            width:200px;
            font-size:10px;
        }

        .student-info {
            display: flex;
            
            
            background-color: #eaf4f9;
            padding: 20px;
        }

        .student-info img {
            width: 220px;
            height: 220px;
            object-fit: cover;
         
            margin-right: 20px;
        }

        .assigned-books {
            background-color: #f0f8ff;
             padding: 12px;
       
        }

        .assigned-books table {
            width: 100%;
            border-collapse: collapse;
            
        }

        .assigned-books th, .assigned-books td {
            padding: 12px;
          
            border-bottom: 1px solid #ddd;
                 font-size:15px;
        }

        .assigned-books th {
            background-color: #e6f7ff;
        }

        .book-form {
            background-color: #f9f9f9;
        }

        .available-books {
            background-color: #f3f6f9;
           
        }

        .available-books table {
            width: 100%;
            border-collapse: collapse;
        }

        .available-books th, .available-books td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        .available-books th {
            background-color: #e6f7ff;
        }

        .message-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            background-color: rgba(0, 0, 0, 0.4);
            visibility: <?php echo $show_message ? 'visible' : 'hidden'; ?>;
            opacity: <?php echo $show_message ? '1' : '0'; ?>;
            transition: opacity 0.4s ease, visibility 0.4s ease;
        }

        .message-overlay .message {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            font-size: 16px;
            color: #333;
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
            max-width: 400px;
            width: 100%;
            display: flex;
            align-items: center;
        }

        .message.success {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }

        .message.error {
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }

        .message .icon {
            margin-right: 12px;
        }

        .barcode-icon {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            font-size: 18px;
            color: #007bff;
        }
        .btn-submit2{
            padding:10px;
              background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
            
        }
        #admission_number{
            width:50px;
        }

    </style>
    <script>
        // Function to simulate barcode scanner
        function scanBarcode() {
            const barcode = prompt("Scan Barcode:");
            if (barcode) {
                document.getElementById('book_no').value = barcode;
            }
        }

        // Function to update the clock every second
        function updateClock() {
            const now = new Date();
            const hours = now.getHours().toString().padStart(2, '0');
            const minutes = now.getMinutes().toString().padStart(2, '0');
            const seconds = now.getSeconds().toString().padStart(2, '0');
            document.getElementById('clock').textContent = `${hours}:${minutes}:${seconds}`;
        }

        // Initialize the clock
        setInterval(updateClock, 1000);
        document.addEventListener('DOMContentLoaded', updateClock);
    </script>
</head>
<body>
    <div class="navbar">
        <div class="clock" id="clock"></div>
        <div class="nav-links">
    <a href="returnbook.php"><i class="fas fa-book-return"></i> Return Book</a>
    <a href="Insert_book.php"><i class="fas fa-book"></i> Add New Book</a>
    <a href="add_student.php"><i class="fas fa-user-plus"></i> Add New Student</a>
    <a href="search_report.php"><i class="fas fa-file-alt"></i> Generate Report</a>
</div>

    </div>

    <div class="container">
        <div class="header">
            <h2><i class="fas fa-book"></i> School Library</h2>
            <i class="fas fa-search search-icon"></i>
        </div>
        <form method="post" action="">
            <div class="form-group">
                <label for="admission_number">Admission Number</label>
                <input type="text" id="admission_number" name="admission_number" required>
                <button type="submit" class="btn-submit"><i class="fas fa-search"></i> Get Student</button>
            </div>
        </form>

        <?php if ($student): ?>
        <div class="dashboard">
            <div class="student-info">
                <img src="<?php echo htmlspecialchars($student['picture']); ?>" alt="Student Picture">
                <div>
                    <p><strong>Full Name:</strong> <?php echo htmlspecialchars($student['fullname']); ?></p>
                    <p><strong>Admission Number:</strong> <?php echo htmlspecialchars($student['admission_number']); ?></p>
                    <p><strong>Class:</strong> <?php echo htmlspecialchars($student['class']); ?></p>
                </div>
            </div>
            <div class="assigned-books">
                <h3>Books Already Assigned</h3>
                <?php if (count($assigned_books) > 0): ?>
                <table>
                    <thead>
                        <tr>
                            <th>Book Name</th>
                            <th>Form</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($assigned_books as $book): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($book['book_name']); ?></td>
                            <td><?php echo htmlspecialchars($book['form']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <?php else: ?>
                <p>No books assigned to this student yet.</p>
                <?php endif; ?>
            </div>
            <div class="book-form">
                <h3>Assign Book</h3>
                <form method="post" action="">
                    <input type="hidden" name="admission_number" value="<?php echo htmlspecialchars($student['admission_number']); ?>">
                    <div class="form-group">
                        <label for="book_no">Book Number</label>
                        <div style="position: relative;">
                            <input type="text" id="book_no" name="book_no" required>
                            <i class="fas fa-barcode barcode-icon" onclick="scanBarcode()"></i>
                        </div>
                    </div>
                    <button type="submit" class="btn-submit2"><i class="fas fa-book"></i> Assign Book</button>
                </form>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Message Overlay -->
    <?php if ($show_message): ?>
    <div id="message-overlay" class="message-overlay">
        <div class="message <?php echo $message_type; ?>">
            <i class="fas <?php echo $message_type == 'success' ? 'fa-check-circle' : 'fa-exclamation-triangle'; ?> icon"></i>
            <?php echo $message; ?>
        </div>
    </div>
    <script>
        // Hide the message overlay after 1.5 seconds
        setTimeout(function() {
            var overlay = document.getElementById('message-overlay');
            if (overlay) {
                overlay.style.opacity = '0';
                overlay.style.visibility = 'hidden';
            }
        }, 1500);
    </script>
    <?php endif; ?>
</body>
</html>
